import React from "react";

export default function SecuritySettingsSvg() {
  return (
    <svg
      width="303"
      height="301"
      viewBox="0 0 303 301"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      className=" tradex-max-w-full"
    >
      <g clipPath="url(#clip0_1972_1645)">
        <path
          d="M72.8391 18.0917C62.6627 32.6241 74.5946 56.1842 59.4949 67.1136C44.7956 77.7525 26.7382 60.3132 12.8855 69.4717C-7.66374 83.0569 -3.91144 145.222 26.134 183.846C35.1694 195.461 42.7188 199.981 46.0623 213.117C53.2424 241.325 28.008 258.104 32.8107 272.056C43.6235 303.468 209.908 329.827 276.63 235.422C307.791 191.331 312.454 127.662 284.612 79.3066C234.301 -8.07339 95.6731 -14.5169 72.8391 18.0917Z"
          className=" tradex-fill-background-primary"
        />
        <path
          d="M90.7467 61.5395C94.6591 61.8684 98.1202 58.7084 98.4769 54.4819C98.8337 50.2554 95.9508 46.5631 92.0383 46.2343C91.8355 46.2177 91.6348 46.2156 91.4352 46.2166C91.249 44.0339 90.9079 41.8957 90.416 39.8178C90.6021 39.742 90.7872 39.6632 90.9692 39.5698C94.5364 37.7408 96.0922 33.1585 94.4449 29.3345C92.7975 25.5095 88.571 23.8921 85.0038 25.7201C84.8177 25.8155 84.6398 25.9234 84.4641 26.0334C83.2993 24.2791 82.0097 22.6275 80.6057 21.091C80.7357 20.923 80.8626 20.7518 80.9811 20.5692C83.2462 17.0741 82.4808 12.2957 79.2703 9.89816C76.0599 7.50065 71.6212 8.39077 69.3561 11.8859C69.2396 12.0654 69.1377 12.249 69.0368 12.4347C67.2241 11.5622 65.3324 10.8402 63.374 10.2748C63.4094 10.0621 63.4406 9.84733 63.4593 9.62843C63.816 5.40193 64.5888 0.630767 60.6711 0.363109C51.6086 -0.256238 49.6472 4.21199 49.2905 8.43849C49.2717 8.65739 49.2676 8.87422 49.2665 9.09C47.2406 9.32031 45.2542 9.71661 43.3209 10.2748C43.2533 10.0756 43.1826 9.87638 43.0983 9.6803C41.451 5.85632 41.7484 3.30423 38.0044 4.73797C29.8395 7.86272 28.5343 12.4772 30.1816 16.3022C30.2679 16.5025 30.3647 16.6923 30.4645 16.8801C28.8234 18.1603 27.2748 19.5733 25.8324 21.1087C25.6784 20.9707 25.5214 20.8358 25.3529 20.7103C22.1425 18.3128 17.7038 19.2029 15.4387 22.698C13.1736 26.1942 13.939 30.9716 17.1495 33.3691C17.3138 33.4925 17.4833 33.6004 17.6538 33.7062C16.8208 35.6732 16.1261 37.7242 15.5759 39.8458C15.3794 39.8115 15.1807 39.7794 14.9779 39.7628C11.0655 39.4339 7.60439 42.5939 7.24664 46.8204C6.88992 51.0469 9.77278 54.7392 13.6852 55.068C13.888 55.0846 14.0888 55.0867 14.2884 55.0857C14.4746 57.2684 14.8157 59.4066 15.3076 61.4846C15.1215 61.5603 14.9363 61.6391 14.7533 61.7325C11.1861 63.5615 9.6303 68.1438 11.2776 71.9678C12.925 75.7928 17.1526 77.4102 20.7187 75.5822C20.9049 75.4868 21.0827 75.3789 21.2585 75.2689C22.4233 77.0232 23.7129 78.6748 25.1168 80.2113C24.9868 80.3793 24.86 80.5505 24.7414 80.7331C22.4763 84.2282 23.2417 89.0066 26.4522 91.4041C29.6627 93.8017 36.6119 92.7051 38.877 89.2089C38.9935 89.0295 36.5859 89.0523 36.6857 88.8666C38.4974 89.7391 40.3902 90.4611 42.3485 91.0265C42.3131 91.2392 42.2819 91.4539 42.2632 91.6728C41.9065 95.8993 44.7894 99.5916 48.7018 99.9204C52.6143 100.249 56.0754 97.0893 56.4331 92.8628C56.4519 92.6439 56.456 92.4271 56.457 92.2113C58.483 91.981 60.4693 91.5847 62.4027 91.0265C62.4703 91.2257 62.541 91.4249 62.6252 91.621C64.2726 95.445 68.5002 97.0633 72.0663 95.2354C75.6335 93.4064 77.1893 88.8241 75.542 85.0001C75.4557 84.7998 75.3589 84.61 75.2591 84.4222C76.9002 83.142 78.4488 81.729 79.8912 80.1936C80.0451 80.3316 80.2032 80.4665 80.3707 80.592C83.5811 82.9895 88.0198 82.1004 90.2849 78.6043C92.55 75.1081 91.7846 70.3308 88.5741 67.9332C88.4098 67.8108 88.2403 67.7019 88.0697 67.5961C88.9028 65.6291 89.5975 63.5781 90.1466 61.4565C90.3452 61.4908 90.5439 61.5219 90.7467 61.5395ZM50.5166 78.4341C36.3103 77.2401 25.8438 63.8333 27.1396 48.4886C28.4344 33.1439 41.0017 21.672 55.208 22.865C69.4143 24.0591 79.8808 37.4659 78.585 52.8106C77.2902 68.1553 64.7229 79.6272 50.5166 78.4341Z"
          fill="#E2E2E2"
        />
        <path
          d="M90.9713 39.5688C94.5385 37.7398 96.0943 33.1574 94.447 29.3334C92.7996 25.5084 88.5721 23.8911 85.0059 25.719C84.8198 25.8145 84.6419 25.9224 84.4662 26.0323C83.3014 24.278 82.0118 22.6264 80.6078 21.09C80.7378 20.9219 80.8647 20.7507 80.9832 20.5671C83.2483 17.072 84.9893 10.1378 81.549 8.08057C75.0209 4.17671 71.6233 8.38765 69.3582 11.8838C69.2417 12.0633 69.1398 12.2469 69.0389 12.4326C67.2272 11.5601 65.3344 10.8381 63.3761 10.2727C63.4115 10.06 63.4427 9.84525 63.4614 9.62635C63.6559 7.32636 62.8853 5.18924 61.5166 3.6611C60.6441 10.2696 59.8225 16.8842 59.0664 23.5062C71.2582 26.5676 79.7602 38.8913 78.585 52.8095C77.5887 64.6041 69.9312 74.1029 59.991 77.3282C60.0138 78.6178 60.0471 79.9094 60.0346 81.201C60.0024 84.7044 59.7746 88.2151 59.5427 91.7226C60.5068 91.5286 61.4605 91.2962 62.4017 91.0255C62.4693 91.2247 62.54 91.4239 62.6242 91.6199C64.2716 95.4439 67.9521 97.7698 74.5155 94.697C78.1461 92.9976 77.1893 88.823 75.542 84.998C75.4557 84.7978 75.3589 84.6079 75.2591 84.4201C76.9002 83.1399 78.4488 81.727 79.8912 80.1916C80.0452 80.3295 80.2032 80.4644 80.3707 80.5899C83.5811 82.9874 90.782 81.6419 93.0482 78.1457C95.3133 74.6496 91.7846 70.3287 88.5752 67.9312C88.4109 67.8087 88.2413 67.6998 88.0708 67.594C88.9038 65.627 89.5985 63.576 90.1487 61.4555C90.3452 61.4897 90.5439 61.5219 90.7467 61.5385C94.6591 61.8674 98.1202 58.7073 98.478 54.4808C98.8347 50.2543 95.9519 46.5621 92.0394 46.2332C91.8366 46.2166 91.6359 46.2146 91.4362 46.2156C91.25 44.0328 90.9079 41.8947 90.417 39.8167C90.6032 39.742 90.7883 39.6632 90.9713 39.5688Z"
          fill="#E2E2E2"
        />
        <path
          d="M94.3961 60.5218C98.3086 60.8507 101.77 57.6907 102.127 53.4652C102.484 49.2387 99.6013 45.5465 95.6889 45.2176C95.4861 45.201 95.2853 45.1989 95.0857 45.2C94.8995 43.0172 94.5584 40.8791 94.0665 38.8011C94.2526 38.7253 94.4378 38.6465 94.6197 38.5531C98.1869 36.7252 99.7428 32.1418 98.0954 28.3178C96.4481 24.4928 92.2215 22.8754 88.6543 24.7034C88.4682 24.7988 88.2904 24.9067 88.1146 25.0167C86.9498 23.2624 85.6602 21.6108 84.2562 20.0744C84.3862 19.9063 84.5141 19.7351 84.6317 19.5515C86.8968 16.0564 86.1313 11.278 82.9209 8.88044C79.7104 6.48293 75.2717 7.37305 73.0066 10.8682C72.8901 11.0476 72.7882 11.2313 72.6873 11.417C70.8746 10.5445 68.9829 9.82243 67.0246 9.25703C67.0589 9.04436 67.0911 8.82961 67.1098 8.61071C67.4666 4.3842 64.5837 0.691976 60.6712 0.363109C56.7588 0.0342427 53.2977 3.19427 52.9399 7.41973C52.9212 7.63863 52.917 7.85546 52.915 8.07124C50.8891 8.30155 48.9027 8.69785 46.9693 9.25599C46.9017 9.05681 46.831 8.85762 46.7468 8.66154C45.0994 4.83756 40.8718 3.21916 37.3057 5.04712C33.7385 6.87508 32.1827 11.4585 33.83 15.2824C33.9164 15.4827 34.0131 15.6725 34.1129 15.8603C32.4718 17.1405 30.9233 18.5535 29.4808 20.0889C29.3269 19.9509 29.1698 19.816 29.0014 19.6905C25.7909 17.293 21.3522 18.1831 19.0871 21.6782C16.822 25.1744 17.5874 29.9518 20.7979 32.3493C20.9622 32.4717 21.1317 32.5806 21.3023 32.6864C20.4693 34.6534 19.7745 36.7044 19.2244 38.8249C19.0278 38.7907 18.8292 38.7585 18.6264 38.7419C14.7139 38.4131 11.2528 41.5731 10.8951 45.7986C10.5384 50.0251 13.4212 53.7173 17.3337 54.0462C17.5365 54.0628 17.7372 54.0648 17.9369 54.0638C18.1241 56.2466 18.4641 58.3847 18.9561 60.4627C18.7699 60.5384 18.5848 60.6173 18.4028 60.7106C14.8356 62.5396 13.2798 67.122 14.9271 70.946C16.5745 74.7699 20.8021 76.3883 24.3682 74.5604C24.5543 74.4649 24.7322 74.357 24.9079 74.2471C26.0727 76.0014 27.3623 77.653 28.7663 79.1894C28.6363 79.3575 28.5094 79.5286 28.3909 79.7112C26.1258 83.2064 26.8912 87.9848 30.1017 90.3823C33.3121 92.7798 37.7508 91.8897 40.0159 88.3946C40.1324 88.2151 40.2343 88.0315 40.3352 87.8458C42.1469 88.7182 44.0397 89.4403 45.998 90.0057C45.9636 90.2184 45.9314 90.4331 45.9127 90.652C45.556 94.8785 48.4388 98.5708 52.3513 98.8996C56.2637 99.2285 59.7248 96.0685 60.0816 91.842C60.1003 91.6231 60.1044 91.4062 60.1065 91.1904C62.1324 90.9601 64.1188 90.5638 66.0522 90.0057C66.1198 90.2049 66.1905 90.4041 66.2747 90.6002C67.9221 94.4241 72.1496 96.0425 75.7158 94.2146C79.283 92.3866 80.8388 87.8032 79.1914 83.9792C79.1051 83.779 79.0084 83.5892 78.9086 83.4014C80.5497 82.1212 82.0982 80.7082 83.5407 79.1728C83.6946 79.3108 83.8517 79.4457 84.0201 79.5712C87.2306 81.9687 91.6693 81.0796 93.9344 77.5835C96.1995 74.0873 95.4341 69.3099 92.2236 66.9124C92.0593 66.79 91.8898 66.6811 91.7192 66.5752C92.5522 64.6083 93.247 62.5573 93.7971 60.4368C93.9958 60.4731 94.1933 60.5042 94.3961 60.5218ZM54.1671 77.4164C39.9608 76.2234 29.4943 62.8156 30.7901 47.4709C32.086 32.1262 44.6522 20.6543 58.8585 21.8484C73.0648 23.0425 83.5313 36.4492 82.2355 51.7939C80.9397 67.1375 68.3734 78.6095 54.1671 77.4164Z"
          className=" tradex-fill-background-primary"
        />
        <path
          d="M206.329 225.775C201.834 225.904 197.449 224.775 193.651 222.504C182.079 215.584 164.979 204.156 149.596 189.197C130.075 170.214 118.86 150.919 116.405 131.971L116.367 131.674L115.891 50.8249C115.891 34.8464 126.338 21.8764 145.953 13.3539C162.159 6.31279 183.638 2.8239 206.329 3.47853C228.757 4.12588 249.51 8.74247 264.871 16.434C283.13 25.5769 292.71 38.4266 292.71 53.6613L292.276 130.913L292.24 131.197C289.998 149.342 279.678 168.096 261.44 187.062C246.81 202.274 230.28 214.329 218.926 221.797C215.169 224.268 210.815 225.645 206.329 225.775Z"
          className=" tradex-fill-primary/50"
        />
        <path
          d="M210.781 225.775C206.344 225.904 202.018 224.775 198.27 222.504C186.851 215.584 169.977 204.156 154.797 189.197C135.534 170.214 124.467 150.919 122.046 131.971L122.007 131.674L121.537 50.8249C121.537 34.8464 131.847 21.8764 151.202 13.3539C167.194 6.31279 188.389 2.8239 210.781 3.47853C232.912 4.12588 253.391 8.74247 268.549 16.434C286.566 25.5769 296.021 38.4266 296.021 53.6613L295.592 130.913L295.558 131.197C293.345 149.342 283.162 168.096 265.164 187.062C250.728 202.274 234.416 214.329 223.212 221.797C219.504 224.268 215.207 225.645 210.781 225.775Z"
          className=" tradex-fill-primary/60"
        />
        <path
          d="M126.887 50.883L127.36 131.324C132.668 172.367 181.021 205.597 202.081 218.221C208.114 221.838 215.827 221.623 221.817 217.691C242.437 204.156 288.143 170.081 293.027 130.62L293.46 53.5814C293.46 -3.57499 126.887 -8.80054 126.887 50.883Z"
          className=" tradex-fill-primary/80"
        />
        <path
          d="M211.975 205.822C211.589 205.831 211.004 205.767 210.415 205.41C201.743 200.172 184.935 189.2 170.311 174.872C154.516 159.395 145.407 144.347 143.317 130.215L142.854 51.1061C142.872 43.5152 148.896 37.0198 160.703 31.8213C173.884 26.0178 192.602 22.973 211.975 23.4326C231.154 23.887 249.326 27.7379 261.915 33.9698C273.051 39.4817 278.681 45.9802 278.7 53.3075L278.268 129.677C276.318 143.354 267.768 158.097 252.756 173.595C238.641 188.168 222.152 199.719 213.534 205.336C212.945 205.721 212.36 205.812 211.975 205.822Z"
          className=" tradex-fill-primary/50"
        />
        <path
          d="M209.997 200.415C201.24 195.034 185.668 184.646 172.081 171.307C157.238 156.735 148.647 142.751 146.628 129.812L146.168 51.1631C146.181 45.7363 151.183 40.7576 160.994 36.4243C173.48 30.9093 191.369 28.0034 209.995 28.4205C228.443 28.8334 245.832 32.4685 257.78 38.3664C267.064 42.9487 271.762 47.9471 271.774 53.24L271.344 129.329C269.449 141.883 261.346 155.612 247.178 170.214C234.023 183.769 218.714 194.67 209.997 200.415Z"
          className=" tradex-fill-background-primary"
        />
        <path
          d="M241.33 97.441L182.361 97.9638C177.828 98.0043 174.135 101.529 174.135 105.835V143.524C174.135 147.804 177.814 151.122 182.331 150.937L241.092 148.537C245.271 148.367 248.661 144.915 248.681 140.824L248.869 104.82C248.891 100.71 245.524 97.4047 241.33 97.441Z"
          className=" tradex-fill-primary/50"
        />
        <path
          opacity="0.8"
          d="M219.915 119.054C219.928 114.892 216.346 111.601 211.973 111.877C208.101 112.121 204.89 115.24 204.672 118.983C204.504 121.887 206.079 124.402 208.475 125.679C209.494 126.221 209.997 127.36 209.797 128.483L208.092 138.004C207.875 139.215 208.838 140.282 210.107 140.237L214.421 140.086C215.683 140.042 216.642 138.914 216.434 137.724L214.784 128.293C214.588 127.168 215.169 126.051 216.191 125.437C218.415 124.103 219.906 121.729 219.915 119.054Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M240.502 93.7031C238.731 93.7145 237.299 92.3109 237.306 90.568L237.342 82.3577C237.378 74.1122 230.544 67.3284 222.028 67.2444L202.781 67.0535C193.967 66.9664 186.719 73.8228 186.712 82.3287L186.704 90.7983C186.702 92.5962 185.168 94.0642 183.272 94.0766C181.372 94.0891 179.83 92.6356 179.83 90.8294L179.833 82.3245C179.838 70.1669 190.216 60.4046 202.793 60.5789L222.049 60.8455C234.146 61.0136 243.808 70.6711 243.752 82.3598L243.713 90.5369C243.705 92.2746 242.269 93.6917 240.502 93.7031Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M301.232 275.943L8.42188 273.453V280.82C8.42188 282.819 9.69899 284.519 11.4285 284.822L94.2265 299.329C95.2093 299.501 96.2057 299.547 97.1968 299.465L298.05 282.925C299.843 282.777 301.232 281.072 301.232 279.018V275.943Z"
          fill="#26264F"
        />
        <path
          d="M194.973 264.138L11.4501 277.614C8.16576 277.854 5.49609 275.292 5.49609 271.889V135.562C5.49609 132.159 8.16576 129.401 11.4501 129.401H194.973C197.678 129.401 199.866 131.895 199.866 134.971V258.209C199.866 261.285 197.678 263.938 194.973 264.138Z"
          fill="#26264F"
        />
        <path
          d="M197.9 264.138L14.3778 277.614C11.0935 277.855 8.42383 275.292 8.42383 271.89V135.563C8.42383 132.16 11.0935 129.401 14.3778 129.401H197.9C200.606 129.401 202.793 131.895 202.793 134.971V258.209C202.792 261.285 200.605 263.939 197.9 264.138Z"
          fill="url(#paint0_linear_1972_1645)"
        />
        <path
          d="M192.181 255.449L21.2486 267.156C18.5758 267.338 16.4043 265.236 16.4043 262.457V143.103C16.4043 140.324 18.5758 138.064 21.2486 138.052L192.181 137.317C194.413 137.307 196.218 139.35 196.218 141.88V250.592C196.218 253.121 194.413 255.297 192.181 255.449Z"
          className=" tradex-fill-background-main"
        />
        <path
          d="M112.617 133.13C112.617 134.396 111.673 135.427 110.506 135.43C109.338 135.434 108.391 134.407 108.391 133.138C108.391 131.868 109.338 130.839 110.506 130.838C111.673 130.837 112.617 131.863 112.617 133.13Z"
          fill="#E2E2E2"
        />
        <path
          d="M205.214 263.39L8.42188 277.576L94.2265 292.609C95.2093 292.782 96.2057 292.827 97.1968 292.745L301.232 275.943L208.344 263.486C207.305 263.347 206.258 263.315 205.214 263.39Z"
          fill="url(#paint1_linear_1972_1645)"
        />
        <path
          d="M37.1367 277.697L200.971 265.712L251.677 272.457L89.2529 285.269L37.1367 277.697Z"
          fill="#26264F"
        />
        <path
          d="M90.2209 262.232L20.4904 266.913C18.4447 267.05 16.709 265.432 16.709 263.387V141.561C16.709 139.615 18.2867 138.035 20.2377 138.026L90.2209 137.744V262.232Z"
          fill="#E8FBF4"
        />
        <path
          d="M180.272 195.799L106.803 198.374V190.964L180.272 188.667V195.799Z"
          fill="#E2E2E2"
        />
        <path
          d="M180.272 207.483L106.803 210.514V203.104L180.272 200.351V207.483Z"
          fill="#E2E2E2"
        />
        <path
          d="M83.0272 197.13L40.8398 198.565V193.026L83.0272 191.707V197.13Z"
          fill="#E2E2E2"
        />
        <path
          d="M83.0272 206.014L40.8398 207.638V202.099L83.0272 200.591V206.014Z"
          fill="#E2E2E2"
        />
        <path
          d="M83.0272 214.898L40.8398 216.712V211.173L83.0272 209.476V214.898Z"
          fill="#E2E2E2"
        />
        <path
          d="M83.0272 223.783L40.8398 225.785V220.246L83.0272 218.359V223.783Z"
          fill="#E2E2E2"
        />
        <path
          d="M139.269 221.113L106.803 222.654V215.244L139.269 213.826V221.113Z"
          fill="#E2E2E2"
        />
        <path
          d="M134.039 163.045V174.177C134.039 177.395 136.753 179.934 140.092 179.846L148.368 179.631C151.666 179.545 154.331 176.894 154.331 173.709V162.695L134.039 163.045ZM141.661 174.552L143.199 169.903C142.541 169.563 142.094 168.895 142.094 168.116C142.094 166.974 143.055 166.029 144.238 166.007C145.421 165.984 146.378 166.891 146.378 168.031C146.378 168.808 145.932 169.493 145.276 169.859L146.809 174.432L141.661 174.552Z"
          fill="#E2E2E2"
        />
        <path
          d="M151.979 161.731C151.101 161.745 150.389 161.068 150.389 160.216C150.389 156.944 147.635 154.317 144.24 154.361C140.831 154.404 138.051 157.119 138.051 160.412C138.051 161.269 137.329 161.976 136.436 161.99C135.544 162.005 134.82 161.322 134.82 160.464C134.82 155.452 139.057 151.327 144.24 151.27C149.394 151.212 153.567 155.203 153.567 160.166C153.567 161.016 152.857 161.716 151.979 161.731Z"
          fill="#E2E2E2"
        />
        <path
          opacity="0.48"
          d="M20.954 285.214L203.548 271.805L204.476 271.737C205.718 271.645 206.847 271.033 207.709 270.105C194.569 269.388 186.408 264.736 181.143 259.93C170.571 250.277 172.404 240.759 161.004 234.413C146.784 226.497 135.602 236.527 124.811 226.631C118.269 220.632 121.481 216.157 113.43 207.192C104.514 197.261 98.7091 200.6 89.7495 191.662C78.4198 180.362 84.0868 171.569 74.3275 163.457C62.4882 153.613 49.7202 162.724 38.4498 153.285C33.5888 149.214 30.9213 143.294 29.5287 137H20.954C17.6697 137 15 139.759 15 143.161V279.491C15 282.892 17.6697 285.455 20.954 285.214Z"
          className=" tradex-fill-background-primary"
        />
        <path
          d="M129.934 128.705C129.934 152.341 111.566 171.833 88.5893 172.502C65.256 173.182 45.6615 154.254 45.1508 129.953C44.6339 105.355 63.8291 85.1931 87.6845 85.1931C111.168 85.1931 129.934 104.789 129.934 128.705Z"
          className=" tradex-fill-primary/60"
        />
        <path
          d="M132.799 128.705C132.799 152.341 114.431 171.833 91.4545 172.502C68.1212 173.182 48.5267 154.254 48.0161 129.953C47.4992 105.355 66.6943 85.1931 90.5497 85.1931C114.033 85.1931 132.799 104.789 132.799 128.705Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M127.375 128.785C127.389 139.229 123.276 148.741 116.608 155.651C110.134 162.359 73.3099 163.735 66.6519 157.91C58.9456 151.168 53.9578 141.181 53.7362 129.869C53.3182 108.56 69.9424 91.0867 90.6113 91.0463C110.999 91.0068 127.347 107.99 127.375 128.785Z"
          className=" tradex-fill-background-primary"
        />
        <mask
          id="mask0_1972_1645"
          style={{ maskType: "luminance" }}
          maskUnits="userSpaceOnUse"
          x="55"
          y="91"
          width="74"
          height="76"
        >
          <path
            d="M128.648 128.739C128.676 149.321 112.674 166.29 92.669 166.835C72.3933 167.388 55.4216 150.909 55.0077 129.823C54.5896 108.514 71.2139 91.0405 91.8828 91.0001C112.272 90.9606 128.619 107.943 128.648 128.739Z"
            fill="white"
          />
        </mask>
        <g mask="url(#mask0_1972_1645)">
          <path
            d="M91.3628 141.778C84.3886 142.65 82.2078 145.239 79.4071 143.509C76.8539 141.933 77.8575 139.291 75.1234 137.47C71.2847 134.913 66.7368 138.395 64.9013 136.198C63.464 134.479 66.1586 132.242 65.6001 127.646C64.9345 122.166 60.5894 121.04 61.1375 116.625C61.5244 113.507 64.0277 111.391 64.2086 111.242C66.1461 109.648 67.1185 110.473 68.9073 109.02C71.5 106.914 70.3435 104.459 72.9903 102.016C73.1962 101.825 75.8191 99.4702 78.625 100.085C80.7934 100.562 80.782 102.313 82.603 102.77C85.8592 103.588 87.622 98.412 91.6676 98.439C94.8572 98.4608 95.0143 101.696 98.8924 102.458C103.655 103.395 107.101 99.2316 108.964 100.882C110.157 101.939 108.832 103.729 110.204 105.744C111.706 107.947 113.963 106.785 116.442 109.086C117.896 110.436 119.2 112.768 119.117 115.167C119.034 117.546 117.649 118.146 117.962 120.251C118.267 122.303 119.682 122.368 120.043 124.328C120.449 126.533 119.156 129.143 117.428 130.571C115.056 132.531 112.905 131.405 111.586 133.352C110.6 134.806 111.484 135.905 110.651 137.614C109.848 139.26 108.048 140.249 104.597 141.052C98.569 142.455 97.114 141.058 91.3628 141.778Z"
            className=" tradex-fill-primary/50"
          />
          <g opacity="0.3">
            <path
              d="M113.749 129.534C109.76 128.769 109.368 124.934 105.139 123.773C97.8533 121.773 91.8411 131.152 88.1637 128.905C84.6381 126.752 89.3264 117.662 84.4551 112.275C80.8494 108.289 75.4227 110.083 74.1831 107.099C73.6215 105.747 74.0011 103.605 76.9494 100.039C74.8507 100.345 73.1566 101.865 72.9923 102.017C70.3455 104.46 71.502 106.915 68.9093 109.021C67.1205 110.473 66.1481 109.649 64.2106 111.243C64.0296 111.392 61.5263 113.507 61.1395 116.626C60.5914 121.039 64.9375 122.166 65.6021 127.647C66.1595 132.244 63.4659 134.48 64.9032 136.199C66.7388 138.396 71.2867 134.914 75.1253 137.471C77.8594 139.292 76.8558 141.934 79.409 143.51C82.2097 145.239 84.3906 142.651 91.3648 141.779C97.116 141.06 98.5709 142.456 104.6 141.054C108.05 140.251 109.851 139.263 110.654 137.616C111.487 135.907 110.603 134.808 111.588 133.354C112.907 131.407 115.059 132.533 117.431 130.573C118.069 130.046 118.647 129.359 119.102 128.591C117.361 129.459 115.55 129.879 113.749 129.534Z"
              fill="url(#paint2_linear_1972_1645)"
            />
          </g>
          <path
            d="M65.5864 168.799C68.0387 172.516 76.5438 170.429 92.5243 169.79C108.456 169.152 115.499 170.615 117.934 166.909C119.065 165.189 118.628 163.236 117.797 159.52C117.228 156.975 116.113 151.993 112.041 148.631C107.02 144.487 100.003 144.864 92.9133 145.245C85.4607 145.645 75.118 146.201 69.4396 152.958C65.4668 157.686 65.158 163.814 65.1236 164.718C65.0404 166.847 65.0009 167.912 65.5864 168.799Z"
            className=" tradex-fill-primary"
          />
          <path
            d="M89.0459 133.185C89.0459 133.185 90.1223 144.509 82.4003 146.927C81.5433 147.195 81.3426 148.344 82.0529 148.892C84.5302 150.804 88.9835 153.838 92.6609 154.157C96.4787 154.489 100.967 150.355 103.26 147.917C103.874 147.265 103.528 146.187 102.662 146.046C99.3761 145.51 93.4513 143.207 93.9713 133.542L89.0459 133.185Z"
            fill="#03150F"
          />
          <path
            d="M83.7517 125.053C83.7517 125.053 83.3378 136.443 91.2896 136.177C99.1998 135.911 98.5592 126.26 98.0995 123.763C98.0995 123.763 98.0984 117.152 92.8101 117.778C87.5061 118.405 83.9327 120.17 83.7517 125.053Z"
            fill="#03150F"
          />
          <path
            d="M97.5127 127.806C97.5127 127.806 98.2459 124.829 99.8235 126.275C102.112 128.374 97.2891 130.862 97.2891 130.862L97.5127 127.806Z"
            fill="#052B1E"
          />
          <path
            d="M84.5476 127.991C84.5476 127.991 83.7458 125.022 82.1816 126.519C79.9071 128.696 84.8367 131.053 84.8367 131.053L84.5476 127.991Z"
            fill="#03150F"
          />
          <path
            d="M83.5064 124.901C83.5781 125.127 83.8881 125.133 83.9671 124.91C84.4912 123.44 86.1615 120.101 90.6324 119.568C94.6208 119.093 96.7673 122.095 97.7054 123.971C97.9103 124.381 98.5083 124.261 98.5488 123.8C98.7932 121.059 98.3856 115.776 91.5861 115.845C82.9666 115.933 82.8075 122.682 83.5064 124.901Z"
            className=" tradex-fill-primary"
          />
        </g>
        <path
          d="M199.722 295.598C199.722 295.598 192.11 299.049 191.987 299.599C191.862 300.15 196.882 299.415 198.931 299.495C200.979 299.575 202.665 298.97 202.48 298.105C202.295 297.238 201.577 295.061 201.577 295.061L199.722 295.598Z"
          fill="url(#paint3_linear_1972_1645)"
        />
        <path
          d="M199.443 292.798L199.906 296.216C199.906 296.216 201.112 296.644 201.921 296.139L202.266 292.389L199.443 292.798Z"
          fill="url(#paint4_linear_1972_1645)"
        />
        <path
          d="M235.288 292.88L236.173 294.298C236.421 294.694 236.495 295.172 236.376 295.624C236.066 296.803 235.449 299.1 235.179 299.7C234.812 300.517 229.887 301.001 229.887 301.001C229.887 301.001 229.448 300.385 230.47 299.64C231.492 298.895 232.15 298.778 232.512 297.679C232.872 296.581 233.113 293.471 233.113 293.471L235.288 292.88Z"
          fill="url(#paint5_linear_1972_1645)"
        />
        <path
          d="M231.604 289.277C231.927 289.534 233.509 294.324 233.509 294.324C233.509 294.324 234.02 294.978 234.994 294.013C235.966 293.049 235.434 293.58 235.434 293.58L235.252 288.869L231.604 289.277Z"
          fill="url(#paint6_linear_1972_1645)"
        />
        <path
          d="M195.257 224.117C194.856 234.314 194.839 245.394 195.428 257.23C196.09 270.558 197.42 282.876 199.098 294.043C199.721 294.063 200.377 294.066 201.061 294.047C201.523 294.035 201.971 294.012 202.404 293.982C203.274 291.666 204.303 288.621 205.224 284.984C206.193 281.16 206.777 277.729 207.193 274.449C208.658 262.899 206.941 261.891 208.131 253.332C209.185 245.751 210.683 245.455 212.442 234.691C214.35 223.013 212.93 221.261 212.239 220.628C209.297 217.933 202.389 219.768 195.257 224.117Z"
          className=" tradex-fill-primary/60"
        />
        <path
          opacity="0.3"
          d="M212.237 220.628C209.432 218.058 203.018 219.613 196.242 223.536C204.036 231.936 204.886 237.386 203.952 240.921C202.896 244.917 199.685 246.068 199.697 250.438C199.712 255.807 204.57 257.23 204.468 262.912C204.399 266.669 202.265 266.63 201.76 271.271C201.163 276.762 203.953 278.655 203.05 282.717C202.661 284.465 201.552 286.749 198.393 289.102C198.621 290.77 198.855 292.421 199.098 294.042C199.721 294.062 200.376 294.065 201.06 294.046C201.522 294.034 201.97 294.011 202.403 293.981C203.274 291.665 204.302 288.62 205.224 284.983C206.192 281.159 206.776 277.728 207.192 274.448C208.658 262.898 206.941 261.89 208.13 253.331C209.184 245.75 210.682 245.454 212.441 234.69C214.348 223.012 212.928 221.261 212.237 220.628Z"
          className=" tradex-fill-primary/60"
        />
        <path
          d="M200.084 223.946C206.795 233.741 214.033 245.932 220.507 260.525C225.4 271.551 228.948 281.905 231.552 291.133C231.905 291.296 232.736 291.621 233.798 291.48C235.248 291.29 236.117 290.366 236.343 290.109C237.403 283.494 237.287 277.892 236.927 273.848C236.697 271.26 236.288 266.948 234.635 261.626C232.782 255.665 231.508 255.33 229.091 249.022C226.583 242.476 227.19 240.842 224.788 232.65C223.801 229.284 222.148 224.276 219.423 218.285C212.976 220.172 206.53 222.06 200.084 223.946Z"
          className=" tradex-fill-primary/60"
        />
        <path
          d="M168.341 154.218C168.341 154.218 167.039 152.663 166.209 151.505C165.379 150.346 161.552 147.125 161.552 147.125C161.552 147.125 161.277 147.655 162.104 148.476C162.931 149.298 164.663 150.699 164.285 151.315C163.907 151.932 162.817 152.491 163.637 153.623C164.456 154.754 165.821 153.94 166.548 154.846C167.275 155.752 168.019 156.742 168.019 156.742L168.341 154.218Z"
          fill="url(#paint7_linear_1972_1645)"
        />
        <path
          d="M168.522 152.584C167.654 153.671 166.784 154.759 165.916 155.846C167.027 160.641 169.396 167.867 174.902 174.885C180.738 182.325 193.188 193.466 200.937 189.814C205.66 187.588 212.038 179.948 209.746 176.265C207.543 172.724 198.009 174.398 191.461 172.923C185.045 171.476 176.715 166.817 168.522 152.584Z"
          className=" tradex-fill-primary/80"
        />
        <path
          d="M228.363 180.864C228.363 180.864 233.441 198.105 230.295 204.74C227.149 211.374 217.117 204.088 217.117 204.088L228.363 180.864Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M227.423 180.885C227.423 180.885 232.501 198.126 229.356 204.76C226.21 211.395 216.178 204.109 216.178 204.109L227.423 180.885Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M212.571 174.488C206.048 174.37 201.024 174.582 198.247 177.474C195.313 180.529 198.418 183.837 197.937 191.671C197.202 203.665 189.618 206.756 189.309 218.914C189.204 223.011 189.971 226.34 190.554 228.343C192.279 230.392 195.09 233.275 199.198 235.647C205.176 239.099 208.584 238.4 217.107 240.529C231.049 244.012 232.38 248.49 239.227 247.192C246.147 245.881 252.113 239.918 251.307 236.733C250.824 234.825 248.036 235.429 244.749 232.575C240.512 228.896 242.035 225.263 238.788 221.282C234.124 215.562 227.881 219.256 223.905 214.299C219.882 209.284 221.214 199.199 224.392 193.648C226.466 190.024 227.297 185.81 229.048 182.019C229.193 181.703 229.359 181.189 229.267 180.552C228.917 178.115 224.805 176.878 221.691 175.973C216.939 174.594 213.108 174.498 212.571 174.488Z"
          className=" tradex-fill-primary"
        />
        <path
          d="M206.221 174.357L207.498 173.935C207.498 173.935 207.872 175.663 212.009 175.791C214.304 175.741 215.758 174.427 215.758 174.427L216.651 175.046C216.651 175.046 214.777 177.489 211.711 177.495C207.754 177.502 206.221 174.357 206.221 174.357Z"
          fill="#03150F"
        />
        <path
          d="M207.269 168.776C206.92 166.885 207.983 165.26 208.217 164.91C209.195 163.447 209.428 163.256 209.852 163.025L210.439 162.734C210.439 162.734 210.472 162.725 210.508 162.715C210.876 162.621 212.093 162.696 212.334 162.77C213.105 163.009 213.648 166.279 212.996 170.772C213.028 171.125 213.059 171.477 213.09 171.83C214.843 171.588 215.352 171.755 215.441 171.989C215.637 172.496 214.415 175.461 212.745 176.045C210.649 176.777 207.731 174.869 207.556 174.178C207.485 173.899 207.498 174.138 208.925 173.315C209.056 172.902 209.465 171.782 209.596 171.37C209.291 171.176 207.527 170.169 207.269 168.776Z"
          fill="#03150F"
        />
        <path
          d="M209.659 167.254C210.046 166.814 210.609 167.312 210.556 167.922C210.504 168.532 209.854 169.112 209.291 168.939C208.727 168.767 209.138 167.846 209.659 167.254Z"
          fill="#052B1E"
        />
        <g opacity="0.3">
          <path
            d="M234.328 236.9C227.768 232.552 221.83 237.526 217.192 233.695C213.373 230.541 216.504 226.427 212.372 220.876C207.841 214.788 201.554 216.344 200.056 211.795C198.507 207.093 204.72 203.901 204.875 197.373C204.954 194.041 203.455 189.701 197.464 184.496C197.788 186.396 198.118 188.71 197.937 191.673C197.202 203.667 189.618 206.758 189.309 218.916C189.204 223.013 189.971 226.342 190.554 228.345C192.279 230.394 195.09 233.277 199.198 235.649C205.176 239.101 208.584 238.402 217.107 240.531C231.049 244.014 232.38 248.492 239.227 247.194C241.222 246.817 243.135 246.051 244.832 245.078C242.838 244.769 241.351 244.092 240.218 243.309C237.222 241.242 237.748 239.167 234.328 236.9Z"
            className=" tradex-fill-primary/60"
          />
        </g>
        <path
          d="M220.526 154.864C216.962 155.267 215.751 152.195 212.602 152.822C208.64 153.612 205.526 159.476 207.03 162.408C207.969 164.238 210.202 163.94 211.53 166.283C212.083 167.258 212.357 168.476 211.959 171.382C210.991 178.443 208.198 179.805 209.173 182.395C210.376 185.592 215.856 186.782 219.244 186.679C220.39 186.645 223.405 186.552 225.887 184.639C228.109 182.925 227.947 181.26 230.231 180.189C232.097 179.313 232.797 180.148 235.314 179.539C237.434 179.027 241.174 177.413 241.742 174.848C242.375 171.991 238.464 170.684 238.798 167.037C239.013 164.679 240.708 164.57 241.314 161.794C242.164 157.895 239.622 154.432 239.171 153.84C237.132 151.161 233.124 148.452 229.314 149.149C225.011 149.939 224.706 154.391 220.526 154.864Z"
          className=" tradex-fill-primary/50"
        />
      </g>
      <defs>
        <linearGradient
          id="paint0_linear_1972_1645"
          x1="8.42284"
          y1="203.516"
          x2="202.793"
          y2="203.516"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#444B8C" />
          <stop offset="0.9964" stopColor="#26264F" />
        </linearGradient>
        <linearGradient
          id="paint1_linear_1972_1645"
          x1="8.42193"
          y1="278.068"
          x2="301.232"
          y2="278.068"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#444B8C" />
          <stop offset="0.9964" stopColor="#26264F" />
        </linearGradient>
        <linearGradient
          id="paint2_linear_1972_1645"
          x1="92.2861"
          y1="140.508"
          x2="87.1252"
          y2="99.4064"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#311944" />
          <stop offset="1" stopColor="#6B3976" />
        </linearGradient>
        <linearGradient
          id="paint3_linear_1972_1645"
          x1="196.034"
          y1="283.626"
          x2="197.916"
          y2="307.633"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0.003597" stopColor="#26264F" />
          <stop offset="1" stopColor="#444B8C" />
        </linearGradient>
        <linearGradient
          id="paint4_linear_1972_1645"
          x1="200.916"
          y1="296.991"
          x2="200.574"
          y2="272.127"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#AB316D" />
          <stop offset="1" stopColor="#792D3D" />
        </linearGradient>
        <linearGradient
          id="paint5_linear_1972_1645"
          x1="231.767"
          y1="280.825"
          x2="233.649"
          y2="304.832"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0.003597" stopColor="#26264F" />
          <stop offset="1" stopColor="#444B8C" />
        </linearGradient>
        <linearGradient
          id="paint6_linear_1972_1645"
          x1="233.663"
          y1="296.54"
          x2="233.321"
          y2="271.677"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#AB316D" />
          <stop offset="1" stopColor="#792D3D" />
        </linearGradient>
        <linearGradient
          id="paint7_linear_1972_1645"
          x1="162.9"
          y1="145.417"
          x2="173.69"
          y2="175.654"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#AB316D" />
          <stop offset="1" stopColor="#792D3D" />
        </linearGradient>
        <clipPath id="clip0_1972_1645">
          <rect width="303" height="301" fill="white" />
        </clipPath>
      </defs>
    </svg>
  );
}
